#pragma once

#include "StdioFileEx.h" 
#include <vector>

using namespace std;

#define MAX_LETTERS		10000
#define ALIASES			_T(":></\\=)(*-;'\'.,!?@\n  \nž l\n s\n c\n t\n z\n y\n a\n i\n e\n u\n n\n o\n d\n r\n")
#define NUM_RESULTS		20



class CSlovnik 
{
public:
	int					num_words;
	int					num_prefixes;
	CString				word;

	vector<CSlovnik*>	next;

public:
	CSlovnik(CString word, int many);
	~CSlovnik();
};

class CPerm
{
public:
	vector<int>			perm;
	int					count;
	
public:
	CPerm(int count);
	CPerm(CPerm* permut);
	~CPerm();
	
	void Generate();
	void swap(int a, int b);
	CString GetString(CString str, CString active_l);
	CString GetPerm(CString active_l);
	inline int GetChar(int ch, CString active_l);
	inline int GetIndex(int ch, CString active_l);
	int	WrongChars(CString code, CString active_l, CString* misplaced);
	bool IsIdentity();

	bool Equals(CPerm* second);
};

class CData 
{
protected:
	// tu toho bude...

	CEdit		*status;
	int			letters[MAX_LETTERS];	// pole pismen...
	CString		active_l;				// aktivne pismena
	int			num_letters;			// # aktivnych pismen

	int			*grams;					// gramy
public:
	int			gr_all;					// pocet spravenych gramov

	int			gr_length;				// dlzka toho pola
	int			ngrams;					// ake je n
	int			gr_empty;				// kolko je prazdnych policok pola

	double		results[NUM_RESULTS];	// pocet vystupov
	CPerm*		perm_res[NUM_RESULTS];	// a permutacia
	int			word_res[NUM_RESULTS];	// pocet slov

	CSlovnik	*slovnik;				// slovnik (root)
	int			num_words;				// pocet slov v slovniku
	int			diff_words;				// pocet roznych slov v slovniku

	CString		code;					// ta sifra
	int			num_perms;				// pocet vyskusanych permutacii

public:
	CData(CEdit *status);
	~CData();

	void SetupLetters(CString alphabet);

	int LoadFromDir(CString dir, int ngrams);
	int LoadFromFile(CString file, int ngrams);

	double Language(CString str, int function = 0);
	double Language(CString str, CPerm* perm, int *wrds = NULL, int value = 0);

	CString Solve(CString str, int many = 50, int slovnik = 0);
	CString GetResult(int i, double* d = NULL);

	void ClearResults();
	CString MissingLetters(CString str);

	int FindWords(CSlovnik* word, CString* str, int str_p, int prefix, CPerm* perm);
	void OutputToFile(CString filename, int param = 0);

	void DoScript(CString filename, bool once = true);
	void ConcatFiles(CString out, CString in);

	void RemoveBadChars(CString &str);

	CString RandomInput(CString file, int chars);

protected:
	int	Char(int ch);
	bool IsSpace(int ch);
	void AddGram(int* temp, int first);

	double GramProbability(int index);
	double CountProb1(CString str);				
	double CountProb2(CString str);				

	int IndexByArray(int* temp, int first = 0);
	int IndexByArray(LPTSTR temp);
	int IndexByPerm(LPTSTR temp, CPerm* perm);

	void MakeAliases(CString text);
	void MakeAlias(CString aliases, int original);

	void GeneratePerm(CArray<int> &perm, int count);
	void AddToResults(double res, CPerm* perm, int wrds, bool erase = false);

};

